% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{decode}
\alias{decode}
\title{Descent-based Calibrated Optimal Direct Estimation}
\usage{
decode(sigma, beta, lambda0, decode.tol = 1e-06, decode.maxit = 100,
  trace = FALSE, solver = c("apg", "homotopy"), solver.tol = 1e-08,
  solver.maxit = 10000, return.sigma = FALSE, return.beta = FALSE,
  return.param = FALSE)
}
\arguments{
\item{sigma}{\eqn{p \times p}{pxp} positive semidefinite symmetric matrix. \code{sigma} will be perturbed if needed.}

\item{beta}{\eqn{p}-length vector.}

\item{lambda0}{number between 0 and 1.}

\item{decode.tol}{error tolerance for \code{DECODE}.}

\item{decode.maxit}{maximum iterations for \code{DECODE}}

\item{trace}{logical. If \code{TRUE}, will return \eqn{\eta}, \eqn{\theta}, and \eqn{\lambda} found during each iteration of \code{DECODE}}

\item{solver}{solver for \eqn{\ell_1}{l1}-RQP problem inside \code{DECODE}.}

\item{solver.tol}{tolerance for solver.}

\item{solver.maxit}{maximum iterations for solver (only for APG).}

\item{return.sigma}{logical. If \code{TRUE} the \code{sigma} entered is returned.}

\item{return.beta}{logical. If \code{TRUE} the \code{beta} entered is returned.}

\item{return.param}{logical. If \code{TRUE} the parameters used are returned.}
}
\value{
An object of class \code{decode} containing:
  \item{eta}{\code{DECODE} of \eqn{\Sigma^{-1}\beta}{\Sigma^-1\beta}.}
  \item{theta}{final \eqn{\theta} of the \code{DECODE}.}
  \item{lambda}{final \eqn{\lambda} of the \code{DECODE}.}
  \item{sigma.mult}{multiplier applied on \code{sigma} to ensure convergence.}
  \item{total.iter}{number of iterations until convergence.}
  \item{call}{the matched call.}
  \item{method}{the solver used, if requested.}
  \item{lambda0}{the \code{lambda0} entered, if requested.}
  \item{decode.tol}{the \code{decode.tol} used, if requested.}
  \item{decode.maxit}{the \code{decode.maxit} used, if requested.}
  \item{trace}{the \code{trace} used, if requested.}
  \item{solver.tol}{the \code{solver.tol} used, if requested.}
  \item{solver.maxit}{the \code{solver.maxit} used, if requested.}
  \item{eta.trace}{matrix of \eqn{\eta} used in each iteration, if requested.}
  \item{theta.trace}{vector of \eqn{\theta} used in each iteration, if requested.}
  \item{lambda.trace}{vector of \eqn{\lambda} used in each iteration, if requested.}
}
\description{
Implement \code{DECODE} for \code{sigma} and \code{beta} to estimate \eqn{\Sigma^{-1}\beta}{\Sigma^-1\beta} where \code{sigma} is an estimator of \eqn{\Sigma} and \code{beta} is an estimator of \eqn{\beta}.
}
\examples{
# estimate A^(-1) b with a certain lambda0
X <- matrix(rnorm(100), 10, 10)
A <- t(X) \%*\% X
b <- rnorm(10)
object <- decode(A, b, lambda0 = 0.8)

object
summary(object)

coef(object)

}
\references{
Pun, C. S. (2018). A Sparse Learning Approach to Relative-Volatility-Managed Portfolio Selection.
Hadimaja, M. Z., & Pun, C. S. (2018). A Self-Calibrated Regularized Direct Estimation for Graphical Selection and Discriminant Analysis.
}
