% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_trig_gtc_order}
\alias{cb_trig_gtc_order}
\title{Spot: Place Trigger Bracket GTC Order}
\usage{
cb_trig_gtc_order(
  client_order_id = cb_get_order_id(),
  product_id,
  side,
  base_size,
  limit_price,
  stop_trigger_price
)
}
\arguments{
\item{client_order_id}{= (string) A unique ID provided for the order (used for identification purposes) Example: 0000-00000-000000}

\item{product_id}{= (string) The trading pair (e.g. 'BTC-USD'). Example: BTC-USD}

\item{side}{= (string) The side of the market that the order is on (e.g. 'BUY', 'SELL'). Possible values: BUY, SELL}

\item{base_size}{= (string) The amount of the first Asset in the Trading Pair. Example: 0.001}

\item{limit_price}{= (string) The specified price, or better, that the Order should be executed at. A Buy Order will execute at or lower than the limit price. A Sell Order will execute at or higher than the limit price. Example: 10000.00}

\item{stop_trigger_price}{= (string) The price level (in quote currency) where the position will be exited. When triggered, a stop limit order is automatically placed with a limit price 5\% higher for BUYS and 5\% lower for SELLS. Example: 20000.00}
}
\value{
returns order details as a \code{data.frame} for trigger GTC orders
}
\description{
Spot: Place Trigger Bracket GTC Order
}
\examples{
\dontrun{
  cb_trig_gtc_order(product_id="BTC-USD", side="BUY",
                    base_size="0.00001", limit_price="100000",
                    stop_trigger_price="115000")
}
}
