% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_bars}
\alias{cb_bars}
\title{Get OHLCV Bars (short-term)}
\usage{
cb_bars(product_id, start_time, end_time, bar_size)
}
\arguments{
\item{product_id}{= The trading pair (e.g. 'BTC-USD').}

\item{start_time}{= The UNIX timestamp indicating the start of the time interval.}

\item{end_time}{= The UNIX timestamp indicating the end of the time interval.}

\item{bar_size}{= The timeframe each candle represents. Examples: ONE_MINUTE, FIVE_MINUTE, FIFTEEN_MINUTE, THIRTY_MINUTE, ONE_HOUR, TWO_HOUR, SIX_HOUR, ONE_DAY}
}
\value{
Get a \code{data.frame} with rates for a single product by product ID, grouped in buckets.

returns OHLCV for cryptocurrencies
}
\description{
Get OHLCV Bars (short-term)
}
\examples{
\dontrun{
  cb_bars(product_id = "ETH-USD", start_time = Sys.time()-hours(1),
          end_time = Sys.time(), bar_size = 'FIVE_MINUTE')
}
}
