% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{simProc}
\alias{simProc}
\title{simProc: Simulated Process}
\usage{
simProc(x1, x2, x3, noise = TRUE)
}
\arguments{
\item{x1}{numeric vector containing the values for factor 1.}

\item{x2}{numeric vector containing the values for factor 2.}

\item{x3}{numeric vector containing the values for factor 3.}

\item{noise}{logical value deciding whether noise should be added or not. Default setting is \code{TRUE}.}
}
\value{
\code{simProc} returns a numeric value within the range [0,1].
}
\description{
This is a function to simulate a black box process for teaching the use of designed experiments.
The optimal factor settings can be found using a sequential assembly strategy i.e. apply a 2^k factorial design first,
calculate the path of the steepest ascent, again apply a 2^k factorial design and augment a star portion
to find the optimal factor settings. Of course, other strategies are possible.
}
\examples{
simProc(120, 140, 1)
simProc(120, 220, 1)
simProc(160, 140, 1)
}
