% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{rsmDesign}
\alias{rsmDesign}
\title{rsmDesign: Generate a response surface design.}
\usage{
rsmDesign(
  k = 3,
  p = 0,
  alpha = "rotatable",
  blocks = 1,
  cc = 1,
  cs = 1,
  fp = 1,
  sp = 1,
  faceCentered = FALSE
)
}
\arguments{
\item{k}{Integer value giving the number of factors. By default, \code{k} is set to `3`.}

\item{p}{Integer value giving the number of additional factors in the response surface design by aliasing effects. Default is `0`.}

\item{alpha}{Character string indicating the type of star points to generate. Should be \code{`rotatable`}(default), \code{`orthogonal`}, or \code{`both`}. If \code{`both`}, values for \code{cc} and \code{cs} will be discarded.}

\item{blocks}{Integer value specifying the number of blocks in the response surface design. Default is `1`.}

\item{cc}{Integer value giving the number of centerpoints (per block) in the cube portion (i.e., the factorial 2^k design) of the response surface design. Default is `1`.}

\item{cs}{Integer value specifying the number of centerpoints in the star portion. Default is `1`.}

\item{fp}{Integer value giving the number of replications per factorial point (i.e., corner points). Default is `1`.}

\item{sp}{Integer value specifying the number of replications per star point. Default is `1`.}

\item{faceCentered}{Logical value indicating whether to use a faceCentered response surface design (i.e., \code{alpha} = `1`). Default is \code{FALSE}.}
}
\value{
The function returns an object of class \code{\link{facDesign.c}}.
}
\description{
Generates a response surface design containing a cube, centerCube, star, and centerStar portion.
}
\details{
Generated designs consist of a cube, centerCube, star, and centerStar portion. The replication structure can be set with the parameters \code{cc} (centerCube), \code{cs} (centerStar), \code{fp} (factorialPoints), and \code{sp} (starPoints).
}
\examples{
# Example 1: Central composite design for 2 factors with 2 blocks, alpha = 1.41,
# 5 centerpoints in the cube portion and 3 centerpoints in the star portion:
rsmDesign(k = 2, blocks = 2, alpha = sqrt(2), cc = 5, cs = 3)

# Example 2: Central composite design with both, orthogonality and near rotatability
rsmDesign(k = 2, blocks = 2, alpha = "both")

# Example 3: Central composite design with:
# 2 centerpoints in the factorial portion of the design (i.e., 2)
# 1 centerpoint in the star portion of the design (i.e., 1)
# 2 replications per factorial point (i.e., 2^3*2 = 16)
# 3 replications per star point (i.e., 3*2*3 = 18)
# Makes a total of 37 factor combinations
rsdo = rsmDesign(k = 3, blocks = 1, alpha = 2, cc = 2, cs = 1, fp = 2, sp = 3)
}
\seealso{
\code{\link{facDesign}}, \code{\link{fracDesign}}, \code{\link{fracChoose}}, \code{\link{pbDesign}}, \code{\link{rsmChoose}}
}
