% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{pcr}
\alias{pcr}
\title{pcr: Process Capability Indices}
\usage{
pcr(
  x,
  distribution = "normal",
  lsl,
  usl,
  target,
  boxcox = FALSE,
  lambda = c(-5, 5),
  main,
  xlim,
  grouping = NULL,
  std.dev = NULL,
  conf.level = 0.9973002,
  bounds.lty = 3,
  bounds.col = "red",
  col.fill = "lightblue",
  col.border = "black",
  col.curve = "red",
  plot = TRUE,
  ADtest = TRUE
)
}
\arguments{
\item{x}{Numeric vector containing the values for which the process capability should be calculated.}

\item{distribution}{Character string specifying the distribution of \code{x}. The function \code{cp} will accept the following character strings for \code{distribution}:
  \itemize{
    \item \code{`normal`}
    \item \code{`log-normal`}
    \item \code{`exponential`}
    \item \code{`logistic`}
    \item \code{`gamma`}
    \item \code{`weibull`}
    \item \code{`cauchy`}
    \item \code{`gamma3`}
    \item \code{`weibull3`}
    \item \code{`lognormal3`}
    \item \code{`beta`}
    \item \code{`f`}
    \item \code{`geometric`}
    \item \code{`poisson`}
    \item \code{`negative-binomial`}
  }
By default \code{distribution} is set to \code{`normal`}.}

\item{lsl}{A numeric value specifying the lower specification limit.}

\item{usl}{A numeric value specifying the upper specification limit.}

\item{target}{(Optional) numeric value giving the target value.}

\item{boxcox}{Logical value specifying whether a Box-Cox transformation should be performed or not. By default \code{boxcox} is set to \code{FALSE}.}

\item{lambda}{(Optional) lambda for the transformation, default is to have the function estimate lambda.}

\item{main}{A character string specifying the main title of the plot.}

\item{xlim}{A numeric vector of length 2 specifying the x-axis limits for the plot.}

\item{grouping}{(Optional) If grouping is given the standard deviation is calculated as mean standard deviation of the specified subgroups corrected by the factor \code{c4} and expected fraction of nonconforming is calculated using this standard deviation.}

\item{std.dev}{An optional numeric value specifying the historical standard deviation (only provided for normal distribution). If \code{NULL}, the standard deviation is calculated from the data.}

\item{conf.level}{Numeric value between \code{0} and \code{1} giving the confidence interval.
By default \code{conf.level} is \code{0.9973} (99.73\%) which is the reference interval bounded by the 99.865\% and 0.135\% quantile.}

\item{bounds.lty}{graphical parameter. For further details see \code{ppPlot} or \code{qqPlot}.}

\item{bounds.col}{A character string specifying the color of the capability bounds. Default is "red".}

\item{col.fill}{A character string specifying the fill color for the histogram plot. Default is "lightblue".}

\item{col.border}{A character string specifying the border color for the histogram plot. Default is "black".}

\item{col.curve}{A character string specifying the color of the fitted distribution curve. Default is "red".}

\item{plot}{A logical value indicating whether to generate a plot. Default is \code{TRUE}.}

\item{ADtest}{A logical value indicating whether to print the Anderson-Darling. Default is \code{TRUE}.}
}
\value{
The function returns a list with the following components:

The function \code{pcr} returns a list with \code{lambda}, \code{cp}, \code{cpl}, \code{cpu}, \code{ppt}, \code{ppl}, \code{ppu}, \code{A}, \code{usl}, \code{lsl}, \code{target}, \code{asTest}, \code{plot}.
}
\description{
Calculates the process capability \code{cp}, \code{cpk}, \code{cpkL} (onesided) and \code{cpkU} (onesided) for a given dataset and distribution.
A histogram with a density curve is displayed along with the specification limits and a Quantile-Quantile Plot for the specified distribution.
Lower-, upper and total fraction of nonconforming entities are calculated. Box-Cox Transformations are supported as well as the calculation of Anderson Darling Test Statistics.
}
\details{
Distribution fitting is delegated to the function \code{FitDistr} from this package, as well as the calculation of lambda for the Box-Cox Transformation. p-values for the Anderson-Darling Test are reported for the most important distributions.

The process capability indices are calculated as follows:
\itemize{
  \item \strong{cpk}: minimum of \code{cpK} and \code{cpL}.
  \item \strong{pt}: total fraction nonconforming.
  \item \strong{pu}: upper fraction nonconforming.
  \item \strong{pl}: lower fraction nonconforming.
  \item \strong{cp}: process capability index.
  \item \strong{cpkL}: lower process capability index.
  \item \strong{cpkU}: upper process capability index.
  \item \strong{cpk}: minimum process capability index.
}

For a Box-Cox transformation, a data vector with positive values is needed to estimate an optimal value of lambda for the Box-Cox power transformation of the values. The Box-Cox power transformation is used to bring the distribution of the data vector closer to normality. Estimation of the optimal lambda is delegated to the function \code{boxcox} from the \code{MASS} package. The Box-Cox transformation has the form \eqn{y(\lambda) = \frac{y^\lambda - 1}{\lambda}} for \eqn{\lambda \neq 0}, and \eqn{y(\lambda) = \log(y)} for \eqn{\lambda = 0}. The function \code{boxcox} computes the profile log-likelihoods for a range of values of the parameter lambda. The function \code{boxcox.lambda} returns the value of lambda with the maximum profile log-likelihood.

In case no specification limits are given, \code{lsl} and \code{usl} are calculated to support a process capability index of 1.
}
\examples{
set.seed(1234)
data <- rnorm(20, mean = 20)
pcr(data, "normal", lsl = 17, usl = 23)

set.seed(1234)
weib <- rweibull(20, shape = 2, scale = 8)
pcr(weib, "weibull", usl = 20)
}
