% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{m_add_property_labels}
\alias{m_add_property_labels}
\title{Add property labels}
\usage{
m_add_property_labels(id, prop, sel = m_sel(), style = m_style_label())
}
\arguments{
\item{id}{R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})}

\item{prop}{Property name ()}

\item{sel}{Atom selection specification}

\item{style}{Style spec to add to specified atoms}
}
\value{
R3dmol \code{id} or a \code{r3dmol} object (the output from
\code{r3dmol()})
}
\description{
This will generate one label per a selected
atom at the atom's coordinates with the property value as the label text.
}
\examples{
library(r3dmol)

r3dmol() \%>\%
  m_add_model(data = "data-raw/Conformer3D_CID_5291.sdf", format = "sdf") \%>\%
  m_set_style(style = m_style_stick(radius = 2)) \%>\%
  m_zoom_to() \%>\%
  m_add_property_labels(
    prop = "index",
    sel = list(not = list(elem = "H")),
    style = m_style_label(
      fontColor = "black",
      font = "sans-serif",
      fontSize = 28,
      showBackground = FALSE,
      alignment = "center"
    )
  )
}
