% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/hashmap.R, R/hashset.R
\name{insert}
\alias{insert}
\alias{insert.r2r_hashmap}
\alias{insert.r2r_hashset}
\title{Insert keys or key/value pairs into an hash table.}
\usage{
insert(x, key, ...)

\method{insert}{r2r_hashmap}(x, key, value, ...)

\method{insert}{r2r_hashset}(x, key, ...)
}
\arguments{
\item{x}{an \code{hashset} or \code{hashmap}.}

\item{key}{an arbitrary R object. Key to be inserted into the hash table.}

\item{...}{further arguments passed to or from other methods.}

\item{value}{an arbitrary R object. Value associated to \code{key}.}
}
\value{
\code{key} for the \code{hashset} method,
\code{value} for the \code{hashmap} method.
}
\description{
These generics are used for inserting a single key or key/value
pair into an \code{hashset} or \code{hashmap}, respectively. For vectorized
insertions, see the \link[r2r]{subsetting_hashtables} documentation page.
}
\examples{
s <- hashset()
insert(s, "foo")
s[["foo"]]
}
\author{
Valerio Gherardi
}
