% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{blip.scorer}
\alias{blip.scorer}
\title{Parent set exploration}
\usage{
blip.scorer(dat, method = "is", indeg = 6, time = 3600,
  scorefunction = "bic", alpha = 1, cores = 1, verbose = 0)
}
\arguments{
\item{dat}{dataframe from which to learn the parent sets.(required)}

\item{method}{Method to be used. Possible values: "is" (independence selection), "sq" (sequential selection). (default: is)}

\item{indeg}{Maximum number of parents (default: 6)}

\item{time}{Maximum Execution time (default: 3600)}

\item{scorefunction}{Chosen score function. Possible choices: BIC, BDeu (default: bic)}

\item{alpha}{(if BDeu is chosen) equivalent sample size parameter (default: 1.0)}

\item{cores}{Number of machine cores to use. If 0, all are used. (default: 1)}

\item{verbose}{Verbose level (default: 0)}
}
\value{
Cache of parent sets
}
\description{
Generates the cache of parent sets from a given data source
}
\details{
Usually the first step in the learning of a Bayesian network.

The input data is required to be complete and discrete. 
Accordingly missing values in the input data.frame will be ignored, and all numeric values will be converted to integers.
}
\examples{
jkl <- blip.scorer(child, time=3)
}
