% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict_sentiment}
\alias{predict_sentiment}
\title{Predict Sentiment on New Data Using a Saved Pipeline Artifact}
\usage{
predict_sentiment(pipeline_object, text_column, threshold = NULL)
}
\arguments{
\item{pipeline_object}{A list object returned by the main `pipeline()` function.
It must contain the trained model, DFM template, preprocessing function,
and n-gram settings.}

\item{text_column}{A string specifying the column name of the text to predict.}

\item{threshold}{Numeric. Optional custom threshold for binary classification.
If NULL, uses the optimized threshold from training (if available).}
}
\value{
A data frame containing the `predicted_class` and probability columns.
}
\description{
This is a generic prediction function that handles different model types
and ensures consistent preprocessing and vectorization for new, unseen text.
}
\examples{
\donttest{
if (exists("my_artifacts")) {
  dummy_df <- data.frame(text = c("loved it", "hated it"), stringsAsFactors = FALSE)
  preds <- predict_sentiment(my_artifacts, df = dummy_df, text_column = "text")
 }
}

}
