% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process.R
\name{pre_process}
\alias{pre_process}
\title{Preprocess a Vector of Text Documents}
\usage{
pre_process(
  doc_vector,
  remove_brackets = TRUE,
  remove_urls = TRUE,
  remove_html = TRUE,
  remove_nums = FALSE,
  remove_emojis_flag = TRUE,
  to_lowercase = TRUE,
  remove_punct = TRUE,
  remove_stop_words = TRUE,
  custom_stop_words = NULL,
  keep_words = NULL,
  lemmatize = TRUE,
  retain_negations = TRUE
)
}
\arguments{
\item{doc_vector}{A character vector where each element is a document.}

\item{remove_brackets}{A logical value indicating whether to remove text in square brackets.}

\item{remove_urls}{A logical value indicating whether to remove URLs and email addresses.}

\item{remove_html}{A logical value indicating whether to remove HTML tags.}

\item{remove_nums}{A logical value indicating whether to remove numbers.}

\item{remove_emojis_flag}{A logical value indicating whether to remove common emojis.}

\item{to_lowercase}{A logical value indicating whether to convert text to lowercase.}

\item{remove_punct}{A logical value indicating whether to remove punctuation.}

\item{remove_stop_words}{A logical value indicating whether to remove English stopwords.}

\item{custom_stop_words}{A character vector of additional custom words to remove (e.g., c("rt", "via")). Default is NULL.}

\item{keep_words}{A character vector of words to protect from deletion (e.g., c("no", "not", "nor")). Default is NULL.}

\item{lemmatize}{A logical value indicating whether to lemmatize words to their dictionary form.}

\item{retain_negations}{Logical. If \code{TRUE} (the default), automatically protects common negation words (e.g., "not", "no", "never") from being deleted by the standard stopword list to preserve sentiment context.}
}
\value{
A character vector of the cleaned and preprocessed text.
}
\description{
This function provides a comprehensive and configurable pipeline for cleaning
raw text data. It handles a variety of common preprocessing steps including
removing URLs and HTML, lowercasing, stopword removal, and lemmatization.
}
\examples{
raw_text <- c(
  "This is a <b>test</b>! Visit https://example.com",
  "Email me at test.user@example.org [important]"
)

# Basic preprocessing with defaults
clean_text <- pre_process(raw_text)
print(clean_text)

# Keep punctuation and stopwords
clean_text_no_stop <- pre_process(
  raw_text,
  remove_stop_words = FALSE,
  remove_punct = FALSE
)
print(clean_text_no_stop)
}
