% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_timeseries.R
\name{detect_ts_outliers}
\alias{detect_ts_outliers}
\title{Detect Anomalies in Time Series using STL Decomposition}
\usage{
detect_ts_outliers(data, frequency = 12)
}
\arguments{
\item{data}{A numeric vector representing the time series values.}

\item{frequency}{Integer. The number of observations per cycle (e.g., 12 for monthly data, 7 for daily data).}
}
\value{
A data frame containing:
\item{Original}{The original values.}
\item{Trend}{The extracted long-term trend component.}
\item{Seasonal}{The extracted seasonal component.}
\item{Remainder}{The remaining noise after removing trend and seasonality.}
\item{Is_Outlier}{Logical flag. TRUE if the Remainder value is an outlier based on IQR (3 * IQR).}
}
\description{
Performs a seasonal-trend decomposition using Loess (STL) to separate the time series
into three components: Trend, Seasonality, and Remainder (Noise). Outliers are then
detected in the Remainder component using the Interquartile Range (IQR) method.
}
\details{
This method is superior to simple thresholding for time series because it accounts for:
\itemize{
\item \strong{Seasonality:} Repeating patterns (e.g., higher sales in December).
\item \strong{Trend:} Long-term increase or decrease.
}
An observation is flagged as an outlier only if it is unusual \emph{after} accounting for
these normal temporal patterns.
}
\examples{
# Example: Synthetic monthly data with a clear anomaly
sales <- c(sin(seq(1, 20, 0.5)) * 10 + 50) # Normal pattern
sales[10] <- 200 # Inject outlier
result <- detect_ts_outliers(sales, frequency = 12)
subset(result, Is_Outlier == TRUE)
}
