% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{rowNA}
\alias{rowNA}
\title{Frequency of Missing Values by Row}
\usage{
rowNA(x, prop = FALSE, ov = FALSE)
}
\arguments{
\item{x}{matrix with any typeof. If not a matrix, it will be coerced to a
matrix via \code{as.matrix}. The argument \code{rownames.force} is set to
TRUE to allow for rownames to carry over for non-matrix objects (e.g.,
data.frames).}

\item{prop}{logical vector of length 1 specifying whether the frequency of
missing values should be returned as a proportion (TRUE) or a count
(FALSE).}

\item{ov}{logical vector of length 1 specifying whether the frequency of
observed values (TRUE) should be returned rather than the frequency of
missing values (FALSE).}
}
\value{
numeric vector of length = \code{nrow(x)}, and names =
  \code{rownames(x)}, providing the frequency of missing values (or observed
  values if \code{ov} = TRUE) per row. If \code{prop} = TRUE, the
  values will range from 0 to 1. If \code{prop} = FALSE, the values will
  range from 1 to \code{ncol(x)}.
}
\description{
\code{rowNA} compute the frequency of missing values in a matrix by row. This
function essentially does \code{apply(X = x, MARGIN = 1, FUN = vecNA)}. It is
also used by other functions in the quest package related to missing values
(e.g., \code{\link{rowMeans_if}}).
}
\examples{
rowNA(as.matrix(airquality)) # count of missing values
rowNA(as.data.frame(airquality)) # with rownames
rowNA(as.matrix(airquality), prop = TRUE) # proportion of missing values
rowNA(as.matrix(airquality), ov = TRUE) # count of observed values
rowNA(as.data.frame(airquality), prop = TRUE, ov = TRUE) # proportion of observed values
}
\seealso{
\code{\link{is.na}}
   \code{\link{vecNA}}
   \code{\link{colNA}}
   \code{\link{rowsNA}}
}
