% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{confint2}
\alias{confint2}
\title{Confidence Intervals from Statistical Information}
\usage{
confint2(obj, ...)
}
\arguments{
\item{obj}{object of a particular class (e.g., "boot") or the first argument
in the default method (e.g., the \code{obj} argument in \code{\link{confint2.default}})}

\item{...}{additional arguments specific to the particular method of \code{confint2}.}
}
\value{
depends on the particular method of \code{confint2}, but usually a data.frame
with a column for the parameter estimate ("est"), standard error ("se"),
lower bound of the confidence interval ("lwr"), and upper bound of the confidence interval ("upr").
}
\description{
\code{confint2} is a generic function for creating confidence intervals from
various statistical information (e.g., \code{\link{confint2.default}}) or
object classes (e.g., \code{\link{confint2.boot}}). It is an alternative to
the original \code{\link[stats]{confint}} generic function in the \code{stats}
package.
}
\seealso{
\code{\link{confint2.default}} for the default method,
   \code{\link{confint2.boot}} for the \code{boot} method,
}
