% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{diff.quantities}
\alias{diff.quantities}
\title{Lagged Differences}
\usage{
\method{diff}{quantities}(x, lag = 1L, differences = 1L, ...)
}
\arguments{
\item{x}{a numeric vector or matrix containing the values to be
    differenced.}

\item{lag}{an integer indicating which lag to use.}

\item{differences}{an integer indicating the order of the difference.}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
S3 method for \code{quantities} objects (see \code{\link{diff}}).
}
\examples{
diff(set_quantities(1:10, m/s, 0.1), 2)
diff(set_quantities(1:10, m/s, 0.1), 2, 2)
x <- cumsum(cumsum(set_quantities(1:10, m/s, 0.1)))
diff(x, lag = 2)
diff(x, differences = 2)

}
