% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_context.R
\name{dplyr_context}
\alias{dplyr_context}
\alias{n}
\title{Context functions from dplyr}
\arguments{
\item{...}{not used; present for compatibility with the generic}
}
\value{
Context-dependent: \code{n()} returns an integer; \code{cur_group_id()} returns
an integer; \code{cur_group()} returns a tibble; \code{cur_data()} and \code{cur_data_all()}
return tibbles; \code{cur_column()} returns a character string.
}
\description{
These functions return information about the "current" group or "current"
variable, so only work inside specific contexts like \code{summarise()} and
\code{mutate()}
}
\details{
\itemize{
\item \code{n()} gives the current group size.
\item \code{cur_data()} gives the current data for the current group (excluding
grouping variables).
\item \code{cur_data_all()} gives the current data for the current group (including
grouping variables)
\item \code{cur_group()} gives the group keys, a tibble with one row and one column
for each grouping variable.
\item \code{cur_group_id()} gives a unique numeric identifier for the current group.
\item \code{cur_column()} gives the name of the current column (in \code{\link[dplyr:across]{dplyr::across()}} only).
}

See \code{\link[dplyr:group_data]{dplyr::group_data()}} for equivalent functions that return values for all
groups.
}
\keyword{internal}
