% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCurv.R
\name{polylocLinData}
\alias{polylocLinData}
\title{Polynomial local linear estimator compared to noise data}
\usage{
polylocLinData(
  x,
  y,
  bandwidth.method = "Plug-in",
  cents = c(0.03, 0.25, 0.5, 0.75, 0.97),
  data,
  leg = FALSE
)
}
\arguments{
\item{x}{the explanatory variable - numeric}

\item{y}{the response variable - numeric}

\item{bandwidth.method}{the bandwidth method choice: CV or plug-in. Default is CV.}

\item{cents}{A numeric vector that represents the centiles calculated. Default is set to cents=c(0.03,0.25,0.5,0.75,0.97)).}

\item{data}{the noise data we want to compare}

\item{leg}{Boolean. Should the legend be displayed (TRUE) or not (FALSE).}
}
\value{
Plots the centile curves and data points to compare with.
}
\description{
Polynomial local linear estimator compared to noise data
}
\examples{
#create a sample data frame
sample<-data.frame(sample(30:42,50,rep=TRUE),sample(800:5000,50,rep=TRUE))
colnames(sample)<-c("Gestational Age in weeks","Weight in gramms")
x<-sample$`Gestational Age in weeks`
y<-sample$`Weight in gramms`
abnormal<-data.frame(sample(30:42,10,rep=TRUE),sample(800:5000,10,rep=TRUE))
colnames(abnormal)<-c("Gestational Age in weeks","Weight in gramms")
polylocLinData(x,y,bandwidth.method="Plug-in",cents=c(0.03,0.25,0.50,0.75,0.97),data=abnormal)


}
