% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{VA}
\alias{VA}
\title{Variance Analog (VA)}
\usage{
VA(x, na.rm = TRUE)
}
\arguments{
\item{x}{a vector of frequencies}

\item{na.rm}{if TRUE, missing values are removed. If FALSE, NA is returned if there is any NA value.}
}
\value{
The value of the VA statistics, which is normalised (varies between
  0 and 1).
}
\description{
Computes the variance analog (VA) for a vector of frequencies of categories.
}
\details{
According to Wilcox (1973, p. 329), the VA is 'based on the variance, which
is defined as the arithmetic mean of the squared differences of each value
from the mean'. The formula for the VA is:
\deqn{1 - \frac{\sum_{i=1}^k \left(f_i - \frac{N}{K}\right)^2}{\frac{N^2(K-1)}{K}}}
}
\examples{
x <- rmultinom(1, 100, rep_len(0.25, 4))
x <- as.vector(t(x))
VA(x)

df <- rmultinom(10, 100, rep_len(0.25, 4))
df <- as.data.frame(t(df))
apply(df, 1, VA)
}
\references{
Wilcox, Allen R. 'Indices of Qualitative Variation and Political
  Measurement.' \emph{The Western Political Quarterly} 26, no. 2 (1 June
  1973): 325-43. doi:10.2307/446831.
}
