% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_and_format_files.R
\name{format_fb_data}
\alias{format_fb_data}
\title{Format the Facebook mobility data}
\usage{
format_fb_data(data, keep_format = NULL)
}
\arguments{
\item{data}{A data.frame with a \code{quadkey} and \code{date_time} columns
and other variables}

\item{keep_format}{Vector of column names,
besides \code{date_time}, \code{day} and \code{quadkey}, that you
don't want to convert to a number.}
}
\value{
A data.frame without \verb{\\N},
\code{quadkey} without scientific notation and
a new column \code{day} and \code{hour}
}
\description{
This function removes unnecessary characters such as \verb{\\\\N}
and ensures that the format of the date and QuadKeys is correct.
}
\examples{
\donttest{
data(result_read_fb_mobility_data)
format_fb_data(data = result_read_fb_mobility_data)
}
}
\seealso{
\code{\link{read_fb_mobility_files}}
}
