% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export2qiskit.R
\name{export2qiskit}
\alias{export2qiskit}
\title{export2qiskit}
\usage{
export2qiskit(object, varname = "qc", filename = "circuit.py",
  append = FALSE, import = FALSE)
}
\arguments{
\item{object}{a qstate object}

\item{varname}{character. The name of the circuit variable}

\item{filename}{character. The filename of the textfile where to store the circuit}

\item{append}{boolean. Whether or not to append to the file. For this the file has to exist.}

\item{import}{boolean. Shall numpy and qiskit be loaded explicitly?}
}
\value{
nothing is returned, but a file is created.
}
\description{
export a circuit to IBM's qiskit python format. Note that only
gates can be exported where the correspondence in qiskit is known
and well defined. Qiskit can then be used for IBM's QASM to run on
real hardware.
}
\details{
Export to IBM's Qiskit

Currently the following gates can be exported: H, X, Y, Z, S,
Tgate, Rz, Rx, Ry, CNOT, SWAP, CCNOT, CSWAP, measure.

note that only standard gates can be exported, not self defined ones.
The function will draw a warning in case a gate cannot be exported
and indicate it in the output file.
}
\examples{
x <- qstate(2)
x <- H(1) * x
x <- X(2) * x
x <- CNOT(c(1,2)) * x
export2qiskit(measure(x,1)$psi)
cat(readLines("circuit.py"), sep = '\n')
file.remove("circuit.py")

}
\references{
https://qiskit.org/documentation/
}
