% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qr_sepa.R
\name{qr_sepa}
\alias{qr_sepa}
\title{Generate a QR code for a SEPA payment}
\usage{
qr_sepa(
  iban,
  beneficiary,
  amount,
  unstructured_reference = "",
  bic = "",
  purpose = "",
  structured_reference = ""
)
}
\arguments{
\item{iban}{the IBAN of the beneficiary.}

\item{beneficiary}{the name of the beneficiary.}

\item{amount}{the amount to transfer. Must be in EUR.}

\item{unstructured_reference}{the unstructured reference.
The unstructured reference is a string of maximum 140 characters.}

\item{bic}{the BIC of the beneficiary.}

\item{purpose}{the purpose of the payment.}

\item{structured_reference}{the structured reference.}
}
\description{
Generate a QR code for a SEPA payment
}
\examples{
qr_sepa(
  iban = "GB33BUKB20201555555555", beneficiary = "John Doe",
  amount = 100, unstructured_reference = "Test payment"
) |>
  plot()
}
\seealso{
Other qr: 
\code{\link{coordinates}()},
\code{\link{generate_svg}()},
\code{\link{plot.qr_code}()},
\code{\link{print.qr_code}()},
\code{\link{qr_code}()},
\code{\link{qr_event}()},
\code{\link{qr_location}()},
\code{\link{qr_wifi}()}
}
\concept{qr}
