% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getScaleCoef.R
\name{getScaleCoef}
\alias{getScaleCoef}
\title{Extract scaling coefficients from vector returned by \code{scale()}}
\usage{
getScaleCoef(z)
}
\arguments{
\item{z}{Object returned by \code{scale()}}
}
\value{
A vector, whose elements are the scaling coefficients
\code{a} and \code{b}, or if \code{scale=FALSE} then \code{a}.
}
\description{
The function \code{scale()} replaces \code{x} by \code{(x-a)/b},
where \code{a} is \code{mean(x)} and \code{b} is \code{sd(x)}.
The quantities \code{a} and \code{b} are available as attributes
of the object that is returned.
}
\details{
Use of a scaled explanatory variable can be helpful in getting a
model to fit.  The scaling coefficient(s) will then be needed when
the fitted model is used with explanatory variable values on the
original scale.
}
\examples{
z <- scale(1:10)
qra::getScaleCoef(z)
}
