% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renaming.R
\name{rename_multi}
\alias{rename_multi}
\title{Rename One Or More Variables}
\usage{
rename_multi(data_frame, ...)
}
\arguments{
\item{data_frame}{The data frame which contains the variable names to be renamed.}

\item{...}{Pass in variables to be renamed in the form: "old_var" = "new_var".}
}
\value{
Returns a data_frame with renamed variables.
}
\description{
Can rename one or more existing variable names into the corresponding new variable
names in one go.
}
\examples{
# Example data frame
my_data <- dummy_data(10)

# Rename multiple variables at once
new_names_df <- my_data |> rename_multi("sex"   = "var1",
                                        "age"   = "var2",
                                        "state" = "var3")

}
