% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-algorithms.R
\name{qgis_search_algorithms}
\alias{qgis_search_algorithms}
\title{Search geoprocessing algorithms}
\usage{
qgis_search_algorithms(
  algorithm = NULL,
  provider = NULL,
  group = NULL,
  include_deprecated = FALSE
)
}
\arguments{
\item{algorithm}{Regular expression to match the \code{algorithm} or
\code{algorithm_title} value from the output of \code{\link[=qgis_algorithms]{qgis_algorithms()}}.}

\item{provider}{Regular expression to match the \code{provider} or
\code{provider_title} value from the output of \code{\link[=qgis_algorithms]{qgis_algorithms()}}.}

\item{group}{Regular expression to match the \code{group} value
from the output of \code{\link[=qgis_algorithms]{qgis_algorithms()}}.}

\item{include_deprecated}{Logical. Should deprecated algorithms be included?}
}
\value{
A tibble.
}
\description{
Searches for algorithms using a regular expression.
In its simplest form
that is just a string that must match part of a character value.
}
\details{
When using multiple arguments in combination, only the algorithms are
returned that fulfill all conditions.

All regular expressions that \code{\link[stringr:str_detect]{stringr::str_detect()}} can handle, are
accepted.
Have a look at \code{\link[stringi:about_search_regex]{stringi::search_regex()}} to get a nice overview.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_search_algorithms(
  algorithm = "point.*line",
  provider = "^native$"
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about information on algorithms & processing providers: 
\code{\link{qgis_algorithms}()},
\code{\link{qgis_show_help}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about information on algorithms & processing providers}
