% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{qgcomp.emm.glm.noboot}
\alias{qgcomp.emm.glm.noboot}
\alias{qgcomp.emm.noboot}
\title{EMM for Quantile g-computation for continuous, binary, and count outcomes under linearity/additivity}
\usage{
qgcomp.emm.glm.noboot(
  f,
  data,
  expnms = NULL,
  emmvar = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  weights,
  alpha = 0.05,
  bayes = FALSE,
  errcheck = TRUE,
  ...
)

qgcomp.emm.noboot(
  f,
  data,
  expnms = NULL,
  emmvar = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  weights,
  alpha = 0.05,
  bayes = FALSE,
  errcheck = TRUE,
  ...
)
}
\arguments{
\item{f}{R style formula}

\item{data}{data frame}

\item{expnms}{character vector of exposures of interest}

\item{emmvar}{(character) name of effect measure modifier in dataset (if categorical, must be coded as a factor variable)}

\item{q}{NULL or number of quantiles used to create quantile indicator variables
representing the exposure variables. If NULL, then gcomp proceeds with un-transformed
version of exposures in the input datasets (useful if data are already transformed,
or for performing standard g-computation)}

\item{breaks}{(optional) NULL, or a list of (equal length) numeric vectors that
characterize the minimum value of each category for which to
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}

\item{id}{(optional) NULL, or variable name indexing individual units of
observation (only needed if analyzing data with multiple observations per
id/cluster). Note that qgcomp.noboot will not produce cluster-appropriate
standard errors (this parameter is essentially ignored in qgcomp.noboot).
Qgcomp.boot can be used for this, which will use bootstrap
sampling of clusters/individuals to estimate cluster-appropriate standard
errors via bootstrapping.}

\item{weights}{"case weights" - passed to the "weight" argument of
\code{\link[stats]{glm}} or \code{\link[arm]{bayesglm}}}

\item{alpha}{alpha level for confidence limit calculation}

\item{bayes}{use underlying Bayesian model (\code{arm} package defaults). Results
in penalized parameter estimation that can help with very highly correlated
exposures. Note: this does not lead to fully Bayesian inference in general,
so results should be interpreted as frequentist.}

\item{errcheck}{(logical, default=TRUE) include some basic error checking. Slightly
faster if set to false (but be sure you understand risks)}

\item{...}{arguments to glm (e.g. family)}
}
\value{
a qgcompfit object, which contains information about the effect
measure of interest (psi) and associated variance (var.psi), as well
as information on the model fit (fit) and information on the
weights/standardized coefficients in the positive (pos.weights) and
negative (neg.weights) directions.
}
\description{
This function fits a quantile g-computation model, allowing
effect measure modification by a binary or continuous covariate. This allows
testing of statistical interaction as well as estimation of stratum specific effects.
}
\examples{
set.seed(50)
# linear model, binary modifier
dat <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
  z=rbinom(50, 1, 0.5), r=rbinom(50, 1, 0.5))
(qfit <- qgcomp.emm.glm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian()))
# logistic model, continuous modifier
dat2 <- data.frame(y=rbinom(50, 1, 0.5), x1=runif(50), x2=runif(50),
  z=runif(50), r=rbinom(50, 1, 0.5))
(qfit2 <- qgcomp.emm.glm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat2, q=2, family=binomial()))
# get weights and stratum specific effects at specific value of Z
#  (note that when Z=0, the effect is equal to psi1)
qgcompint::getstratweights(qfit2, emmval=0)
qgcompint::getstrateffects(qfit2, emmval=0)
qgcompint::getstratweights(qfit2, emmval=0.5)
qgcompint::getstrateffects(qfit2, emmval=0.5)
# linear model, categorical modifier
dat3 <- data.frame(y=runif(50), x1=runif(50), x2=runif(50),
  z=as.factor(sample(0:2, 50, replace=TRUE)), r=rbinom(50, 1, 0.5))
(qfit3 <- qgcomp.emm.glm.noboot(f=y ~ z + x1 + x2, emmvar="z",
  expnms = c('x1', 'x2'), data=dat3, q=2, family=gaussian()))
# get weights and stratum specific effects at each value of Z
#  (note that when Z=0, the effect is equal to psi1)
qgcompint::getstratweights(qfit3, emmval=0)
qgcompint::getstrateffects(qfit3, emmval=0)
qgcompint::getstratweights(qfit3, emmval=1)
qgcompint::getstrateffects(qfit3, emmval=1)
qgcompint::getstratweights(qfit3, emmval=2)
qgcompint::getstrateffects(qfit3, emmval=2)
}
\seealso{
\code{\link[qgcomp]{qgcomp.noboot}}
}
\concept{variance mixtures}
