% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.cpn.r
\name{qcs.cpn}
\alias{qcs.cpn}
\title{Process capability indices (Nonparametric)}
\usage{
qcs.cpn(
  object,
  parameters = c(u = 0, v = 0),
  limits = c(lsl = -3, usl = 3),
  q = c(lq = -3, uq = 3),
  target = NULL,
  median = 0,
  nsigmas = 3,
  confidence = 0.9973
)
}
\arguments{
\item{object}{qcs object of type \code{"qcs.xbar"} or \code{"qcs.one"}.}

\item{parameters}{A vector specifying the \code{u} and \code{v} parameters values. 
If parameters = c(u=0, v=0), the cp indice is calculed; If parameters = c(u=1, v=0), the cpk indice is calculed;
If parameters = c(u=0, v=1), the cpm indice is calculed; If parameters = c(u=1, v=1), the cpmk indice is calculed.}

\item{limits}{A vector specifying the lower and upper specification limits.}

\item{q}{A vector specifying the lower and upper quantiles. These values are necessary, if \code{object} value is missing.}

\item{target}{A value specifying the target of the process. 
If is \code{NULL}, the target is set at the middle value bewteen specification limits.}

\item{median}{A value specifying the median of data.}

\item{nsigmas}{A numeric value specifying the number of sigmas to use.}

\item{confidence}{A numeric value between 0 and 1 specifying the probabilities for computing the quantiles.
This values is used only when object values is provided. The default value is 0.9973.}
}
\description{
Calculates \eqn{CNp}{CNpk}, \eqn{CNpm}{CNpmk} using the formulation described by Tong and Chen (1998).
}
\examples{
library(qcr)
##' data(pistonrings) 
xbar <- qcs.xbar(pistonrings[1:125,],plot = TRUE)
x<-xbar$statistics[[1]]
LSL=73.99; USL=74.01
median <-median(x)
lq=as.numeric(quantile(x,probs=0.00135))
uq=as.numeric(quantile(x,probs=0.99865))
qcs.cpn(parameters = c(0,0),limits = c(LSL,USL),
       median = median, q=c(lq,uq))
qcs.cpn(object = xbar,parameters = c(0,0), limits = c(LSL,USL))
qcs.cpn(object = xbar,parameters = c(1,0), limits = c(LSL,USL))
qcs.cpn(object = xbar,parameters = c(0,1), limits = c(LSL,USL))
qcs.cpn(object = xbar,parameters = c(1,1), limits = c(LSL,USL))
}
\references{
Montgomery, D.C. (1991) \emph{Introduction to Statistical Quality Control}, 2nd
ed, New York, John Wiley & Sons. \cr
Tong, L.I. and Chen, J.P. (1998), \emph{Lower confidence limits of process capability 
indices for nonnormal process distributions.} International Journal of Quality & Reliability Management, 
Vol. 15 No. 8/9, pp. 907-19.\cr
}
