% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.r
\name{qcs}
\alias{qcs}
\alias{summary.qcs}
\alias{print.qcs}
\alias{qcs.continuous}
\alias{qcs.atributte}
\alias{qcs.dependence}
\title{Quality Control Statistics}
\usage{
qcs(
  x,
  sample.index,
  sizes = NULL,
  type = c("xbar", "R", "S", "one", "p", "np", "c", "u", "ewma", "cusum"),
  center = NULL,
  std.dev,
  conf.nsigma = 3,
  limits = NULL,
  type.data = c("continuous", "atributte", "dependence"),
  lambda = 0.2,
  decision.interval = 5,
  se.shift = 1
)

qcs.continuous(
  x,
  sample.index,
  sizes = NULL,
  type = c("xbar", "R", "S", "one"),
  center = NULL,
  std.dev,
  conf.nsigma = 3,
  limits = NULL
)

qcs.atributte(
  x,
  sample.index = NULL,
  sizes = NULL,
  type = c("p", "np", "c", "u"),
  center = NULL,
  conf.nsigma = 3,
  limits = NULL
)

qcs.dependence(
  x,
  sample.index = NULL,
  sizes = NULL,
  type = c("ewma", "cusum"),
  center = NULL,
  std.dev,
  nsigma = 3,
  lambda = 0.2,
  decision.interval = 5,
  se.shift = 1
)
}
\arguments{
\item{x}{a vector containing observed data}

\item{sample.index}{a scalar with the column number corresponding to the index 
of each group (sample).}

\item{sizes}{a value or a vector of values specifying the sample sizes
associated with each group. For continuous data the sample sizes are obtained counting the non-\code{NA} elements of
the sample.index vector. For \code{"p"}, \code{"np"} and \code{"u"} charts the argument
\code{sizes} is required.}

\item{type}{a character string specifying the group statistics to compute:

\tabular{lll}{ \tab Statistic charted \tab Chart description \cr
\code{"xbar"} \tab mean \tab means of a continuous process variable \cr
\code{"R"} \tab range \tab ranges of a continuous process variable \cr
\code{"S"} \tab standard deviation \tab standard deviations of a continuous
variable \cr \code{"one"} \tab mean \tab one-at-time data of a
continuous process variable \cr \code{"p"} \tab proportion \tab proportion
of nonconforming units \cr \code{"np"} \tab count \tab number of
nonconforming units \cr \code{"c"} \tab count \tab nonconformities per unit
\cr \code{"u"} \tab count \tab average nonconformities per unit \cr
\code{"g"} \tab count \tab number of non-events between events }}

\item{center}{a value specifying the center of group statistics or the
''target'' value of the process.}

\item{std.dev}{a value or an available method specifying the within-group standard
deviation(s) of the process. Several methods are available for estimating the
standard deviation in case of a continuous process variable.}

\item{conf.nsigma}{a numeric value used to compute control limits, specifying the
number of standard deviations (if \code{conf.nsigma} > 1) or the confidence level (if 0
< \code{conf.nsigma} < 1).}

\item{limits}{a two-value vector specifying control limits.}

\item{type.data}{a string specifying el type de data.}

\item{lambda}{the smoothing parameter \eqn{0 \le \lambda \le 1}{0 <= lambda
<= 1}}

\item{decision.interval}{A numeric value specifying the number of standard
errors of the summary statistics at which the cumulative sum is out of
control.}

\item{se.shift}{The amount of shift to detect in the process, measured in
standard errors of the summary statistics.}

\item{nsigma}{a numeric value used to compute control limits, specifying the
number of standard deviations.}
}
\value{
Returns an object of class 'qcs'.
}
\description{
Create an object of class 'qcs' to perform statistical quality control.
This object may then be used to plot Shewhart charts, Multivariate Control Charts,
and more.
}
\references{
Montgomery, D.C. (2000) \emph{Introduction to Statistical
Quality Control}, 4th ed. New York: John Wiley & Sons. \cr Wetherill, G.B.
and Brown, D.W. (1991) \emph{Statistical Process Control}. New York:
Chapman & Hall.
}
