% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcapower.R
\name{qp_cases_brute}
\alias{qp_cases_brute}
\title{Calculate the number of cases for a particular case target with iterative
simulations (brute force)}
\usage{
qp_cases_brute(
  power_target,
  start_value = 2,
  max_value = 100,
  progress = TRUE,
  ...
)
}
\arguments{
\item{power_target}{Power level target}

\item{start_value}{Default number of cases for initial search}

\item{max_value}{Default maximum number of cases for search}

\item{progress}{Show progress of calculation (default \code{TRUE})}

\item{...}{\code{qcapower} parameters -- see \code{\link{qcapower}}}
}
\value{
An integer showing how many cases are needed to achieve the
target level of power.
}
\description{
\code{qp_cases_brute} calculates the number of cases needed for a particular
power level. The function starts with the number of cases given by \code{start_value}
and iteratively simulates power and adjusts the number of cases
 until the \code{power_target} is met or the \code{max_value} has been reached.
 Running the function can take a lot of time. Use \code{\link{qp_cases}} to
}
\examples{
\dontrun{
qp_cases_brute(power_target = 0.9, null_hypo = 0.80, alt_hypo = 1)

qp_cases_brute(power_target = 0.9, null_hypo = 0.80, alt_hypo = 1, start_value = 20,
               max_value = 50, perms = 500)
}

}
\seealso{
\code{\link{qp_cases_brute}}
}
