% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_export.R
\name{import_model}
\alias{import_model}
\title{Import Model Specification from JSON}
\usage{
import_model(file)
}
\arguments{
\item{file}{Character string specifying JSON file path}
}
\value{
A list containing the model specification components
}
\description{
Import a previously exported model specification from JSON format.
}
\examples{
\dontrun{
# Import model
spec <- import_model("my_model.json")

# Recreate model
fit <- qbrms(
  formula = as.formula(spec$model$formula),
  data = my_data,
  family = get(spec$model$family)()
)
}

}
