% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat_prior_wrappers.R, R/family_conversion.R
\name{generate_prior_predictive_samples}
\alias{generate_prior_predictive_samples}
\title{Generate prior predictive samples (compat wrapper) - FIXED}
\usage{
generate_prior_predictive_samples(
  formula,
  data,
  family = gaussian(),
  prior = NULL,
  ndraws = 100,
  verbose = TRUE,
  ...
)

generate_prior_predictive_samples(
  formula,
  data,
  family = gaussian(),
  prior = NULL,
  ndraws = 100,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{formula}{Model formula}

\item{data}{Data frame containing model variables}

\item{family}{Model family specification}

\item{prior}{Prior specifications (currently uses default priors)}

\item{ndraws}{Number of draws from prior predictive distribution}

\item{verbose}{Logical; print progress messages}

\item{...}{Additional arguments (currently ignored)}
}
\value{
A list with elements:
\itemize{
\item \code{prior_samples} – numeric matrix \code{ndraws × n}.
\item \code{eta} – numeric matrix \code{n × ndraws} of linear predictors.
\item \code{coef_draws} – numeric matrix \code{ndraws × p} of coefficient draws.
}

Matrix of prior predictive samples (ndraws x nrow(data))
}
\description{
Maintains the legacy API: returns a list with \code{$prior_samples}
as a numeric matrix of size \code{ndraws × nrow(data)}.

Generate samples from the prior predictive distribution for qbrms models.
Returns an ndraws x nobs matrix for compatibility with qbrms structure.
}
\details{
Uses simple default priors:
\itemize{
\item Intercept: Normal(0, 2.5)
\item Other coefficients: Normal(0, 1.0)
}

For families other than gaussian, binomial, and poisson, falls back to
Gaussian-like sampling.
}
\keyword{internal}
