% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_get.R
\name{pxweb_get}
\alias{pxweb_get}
\title{Do a GET call to PXWEB API}
\usage{
pxweb_get(url, query = NULL, verbose = TRUE)
}
\arguments{
\item{url}{a \code{pxweb} object or url that can be coherced to a \code{pxweb} object.}

\item{query}{a json string, json file or list object that can be coherced to a \code{pxweb_query} object.}

\item{verbose}{should large queries print out progress.}
}
\description{
Do a GET call to PXWEB API
}
\examples{
\dontrun{
url <- "https://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy"
px_meta_data <- pxweb_get(url)

url <- "https://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101"
px_levels <- pxweb_get(url)

url <- "https://api.scb.se/OV0104/v1/doris/sv"
px_levels <- pxweb_get(url)

url <- "https://api.scb.se/OV0104/v1/doris/sv/ssd/BE/BE0101/BE0101A/BefolkningNy"
query <- file.path(
  system.file(package = "pxweb"),
  "extdata", "examples", "json_query_example.json"
)
px_data <- pxweb_get(url = url, query = query)

# Convert to data.frame
as.data.frame(px_data, column.name.type = "text", variable.value.type = "text")

# Get raw data
as.matrix(px_data, column.name.type = "code", variable.value.type = "code")

# Get data comments
pxweb_data_comments(px_data)

# Get jsonstat data
jstat <- query <- file.path(
  system.file(package = "pxweb"),
  "extdata", "examples", "json-stat_query_example.json"
)
jstat_data <- pxweb_get(url = url, query = query)

# Get very large datasets (multiple downloads needed)
big_query <- file.path(
  system.file(package = "pxweb"),
  "extdata", "examples", "json_big_query_example.json"
)
px_data <- pxweb_get(url = url, query = big_query)
}

}
