% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitLeafArea.R
\name{FitLeafArea}
\alias{FitLeafArea}
\title{Leaf area fitting}
\usage{
FitLeafArea(data, sample = "sample", fresh.weight = "fresh.weight",
  leaf.area = "leaf.area")
}
\arguments{
\item{data}{data frame, with columns of equal length, containing at least columns with the the fresh.weight (g)
and the leaf.area (cm^2) values, ordered by sample by descending fresh weight. A column containing the sample IDs is optionally required
if several samples were measured.At least 3 leaf area values are required.}

\item{sample}{string, optional name of the column in data containing the sample ID, default: "sample"}

\item{fresh.weight}{optional name of the column in data containing the numeric fresh weight values (g);
default: "fresh.weight"}

\item{leaf.area}{optional name of the column in data containing the numeric single-sided leaf area values (cm^2);
default: "leaf.area"}
}
\value{
the original data frame extended by a numeric column containing the fitted leaf area values (leaf.area.fitted)
}
\description{
Fits randomly measured leaf area values linearly to fresh weight values. Useful if the leaf area changes during a measurement
series but is only randomly measured.
}
\details{
fits given leaf area values linearly to the respective fresh weight values and calculates leaf area values
for the fresh weight values based on the fit
}
\examples{
# get example data
df <- data.frame(
  sample = c(as.integer(rep(1, times = 6))),
  fresh.weight = c(1.23, 1.19, 1.15, 1.12, 1.09, 1.0),
  leaf.area = c(10.5, NA, NA, 9.8, NA, 8.4))
# fit leaf area
df_new <- FitLeafArea(df)

}
