% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_errorbar.R
\name{plot_errorbar}
\alias{plot_errorbar}
\title{Plot Mean with Error Bars}
\usage{
plot_errorbar(
  data,
  var,
  by,
  error = c("sd", "se", "ci"),
  err.mult = 1.5,
  point.shape = 19,
  point.size = 3,
  line.color = "blue",
  line.size = 1,
  color.point = "black",
  color.error = "black",
  show.mean = TRUE,
  text.size = 3.5,
  err.width = 0.05,
  x.lab = "Group",
  y.lab = NULL,
  title = NULL,
  rotate = FALSE,
  theme_fun = ggthemes::theme_stata
)
}
\arguments{
\item{data}{A data frame containing the variables to plot.}

\item{var}{A numeric variable to be summarized and plotted.}

\item{by}{A grouping (categorical) variable to calculate summary statistics by.}

\item{error}{Type of error to display: "sd" (standard deviation), "se" (standard error), or "ci" (95\% confidence interval). Default is "sd".}

\item{err.mult}{Numeric multiplier for the error bars. Useful to extend or shrink error bars. Default is 1.5.}

\item{point.shape}{Shape of the points. Default is 19 (solid circle).}

\item{point.size}{Size of the points. Default is 3.}

\item{line.color}{Color of the connecting line. Default is "blue".}

\item{line.size}{Thickness of the connecting line. Default is 1.}

\item{color.point}{Color of the points. Default is "black".}

\item{color.error}{Color of the error bars. Default is "black".}

\item{show.mean}{Logical; if TRUE, mean values are displayed above points. Default is TRUE.}

\item{text.size}{Size of the mean value text labels. Default is 3.5.}

\item{err.width}{Width of the error bars (horizontal whiskers). Default is 0.05.}

\item{x.lab}{Label for the x-axis. Default is "Group".}

\item{y.lab}{Label for the y-axis. If NULL, uses the name of \code{var}.}

\item{title}{Plot title. Default is NULL.}

\item{rotate}{Logical; if TRUE, rotates x-axis labels by 45 degrees. Default is FALSE.}

\item{theme_fun}{ggplot2 theme function to customize the plot appearance. Default is \code{ggthemes::theme_stata}.}
}
\value{
A ggplot2 object displaying the line plot with points and error bars.
}
\description{
This function creates a line plot with points and customizable error bars
(standard deviation, standard error, or confidence interval) for a numeric
variable grouped by a categorical variable. Mean values can optionally be
displayed above the points.
}
\examples{
plot_errorbar(
  data = iris,
  var = Sepal.Length,
  by = Species,
  error = "se",
  err.mult = 1,
  point.shape = 19,
  point.size = 3,
  line.color = "red",
  line.size = 0.5,
  color.point = "blue",
  color.error = "blue",
  show.mean = TRUE,
  text.size = 3,
  err.width = 0.05,
  title = "Mean Sepal Length by Species",
  rotate = TRUE
)
}
