% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_plot.R
\name{plot_cor}
\alias{plot_cor}
\title{Correlation Heatmap Plot}
\usage{
plot_cor(
  data,
  method = "pearson",
  conf.level = 0.95,
  stars = TRUE,
  plot.title = NULL,
  var.labels = NULL
)
}
\arguments{
\item{data}{A data frame containing numeric variables to correlate.}

\item{method}{Correlation method: "pearson", "spearman", or "kendall". Default is "pearson".}

\item{conf.level}{Confidence level for correlation confidence intervals. Default is 0.95.}

\item{stars}{Logical. If TRUE, adds significance stars based on p-values. Default is TRUE.}

\item{plot.title}{Character string specifying the plot title. If NULL, a default title is used.}

\item{var.labels}{Optional character vector of variable labels to replace column names in the plot. Must match number of numeric columns.}
}
\value{
A ggplot object showing the correlation heatmap with correlation coefficients and significance stars.
}
\description{
Creates a publication-ready correlation heatmap for numeric variables in a data frame.
Each tile shows the correlation coefficient, with optional significance stars.
}
\examples{
plot_cor(mtcars)
plot_cor(mtcars, var.labels = colnames(mtcars))
plot_cor(mtcars, method = "spearman", stars = FALSE)
}
