% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateProtocolHistory.R
\name{CreateProtocolHistory}
\alias{CreateProtocolHistory}
\title{Create a Subject History Table by Protocol}
\usage{
CreateProtocolHistory(start_vec, end_vec, persons_df = "everybody")
}
\arguments{
\item{start_vec}{a named integer vector with the number of days before
subject consent when the subject history should start, per protocol}

\item{end_vec}{a named integer vector with the length of the study phase of
interest, per protocol}

\item{persons_df}{Either the name of the data frame that contains all the
subject IDs and their clinical trials (which defaults to
\code{"everybody"}), or a data frame with this information. See "Details"
for more information.}
}
\value{
A tibble with columns \code{who}, \code{project}, and \code{when}.
Each subject will have one row for each day in the study range.
}
\description{
Create a Subject History Table by Protocol
}
\details{
We may want to perform SQL-like operations on a set of tables. This
data table will form the "backbone" for future join operations. It creates
one record per person in each study for each day in those studies (when
\code{persons_df} is set to \code{"everybody"}), or it creates one record
per person contained in the table \code{persons_df} for each day in those
studies. The default behavior is to use the supplied \code{"everybody"}
table for all consenting subjects in the CTN-0027, CTN-0030, and CTN-0051
clinical trials. However, users may only care about a smaller subset of
these patients, so a subset of the \code{"everybody"} data frame can be
supplied to the \code{persons_df} argument if desired.

NOTE: this function is only appropriate for trial with fixed start and
end days (such as CTN-0027 or CTN-0051). For studies with variable-length
(i.e., subject-specific) protocol lengths, please use
\code{CreateSubjectProtocolHistory()} instead.
}
\examples{
   start_int <- c(`27` = -30L, `51` = -30L)
   end_int   <- c(`27` = 168L, `51` = 168L)
   
   CreateProtocolHistory(
     start_vec = start_int, end_vec = end_int
   )
   
}
