% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routes.R
\name{routes}
\alias{routes}
\title{Information for all routes}
\usage{
routes(
  route_types = NULL,
  route_name = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_types}{Integer or character vector. Optionally filter by a vector
of route types. A route type can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the
\code{\link{route_types}} function to extract a vector of all route types.}

\item{route_name}{Character. Optionally filter by route name. Partial matches
are accepted, and the matches are not case sensitive.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble of routes, with the following columns:
\itemize{
\item \code{route_id}
\item \code{route_gtfs_id}
\item \code{route_name}
\item \code{route_type}
\item \code{route_type_description}
\item \code{route_number}
\item \code{geopath}
\item \code{service_status}
\item \code{service_status_timestamp}
}
}
\description{
Information for all routes
}
\examples{
\dontrun{
routes()
routes(route_types = "Train")
routes(route_types = 0)
routes(route_types = c("Train", "Tram"))
routes(route_name = "Frankston")
routes(route_name = "Craigie")
routes(route_name = "werribee")
}
}
