% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptv-verbs.R
\name{PTVGET}
\alias{PTVGET}
\title{Submit a GET request to the PTV API}
\usage{
PTVGET(
  request,
  user_id = determine_user_id(),
  api_key = determine_api_key(),
  ...
)
}
\arguments{
\item{request}{A request or path for the API, eg. "routes".}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{...}{Additional arguments passed to \code{httr::GET}.}
}
\value{
A HTTP response. Content can be accessed with \code{httr::content}.
}
\description{
Submit a GET request to the PTV API
}
\section{Obtaining API authentication details}{


You will need to obtain a user ID (also called a devid) and an API key from
Public Transport Victoria. These are obtained by email. Instructions are
available at \url{https://www.ptv.vic.gov.au/footer/data-and-reporting/datasets/ptv-timetable-api/}.
You may pass these two pieces of information directly to the function, or you
can set the PTV_USER_ID and PTV_API_KEY environment variables.
}

\keyword{internal}
