% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{pte_emp_boot}
\alias{pte_emp_boot}
\title{Class for Empirical Bootstrap Results}
\usage{
pte_emp_boot(
  attgt_results,
  overall_results,
  group_results,
  dyn_results,
  overall_weights = NULL,
  dyn_weights = NULL,
  group_weights = NULL,
  extra_gt_returns = NULL
)
}
\arguments{
\item{attgt_results}{\code{data.frame} holding attgt results}

\item{overall_results}{\code{data.frame} holding overall results}

\item{group_results}{\code{data.frame} holding group results}

\item{dyn_results}{\code{data.frame} holding dynamic results}

\item{overall_weights}{vector containing weights on underlying ATT(g,t)
for overall treatment effect parameter}

\item{dyn_weights}{list containing weights on underlying ATT(g,t)
for each value of \code{e} corresponding to the dynamic treatment
effect parameters.}

\item{group_weights}{list containing weights on underlying ATT(g,t)
corresponding to deliver averaged group-specific treatment effects}

\item{extra_gt_returns}{A place to return anything extra from particular
group-time average treatment effect calculations.  For DID, this might
be something like propensity score estimates, regressions of untreated
potential outcomes on covariates.  For ife, this could be something
like the first step regression 2sls estimates.  This argument is also
potentially useful for debugging.}
}
\value{
a \code{pte_emp_boot} object
}
\description{
Class for holding \code{ptetools} empirical bootstrap results
}
