% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_simulation_obj.R
\name{create_simulation_obj}
\alias{create_simulation_obj}
\title{Compile MCMC sampler using STAN and create simulation object}
\usage{
create_simulation_obj(
  data_matrix_list,
  covariate = NULL,
  outcome,
  borrowing,
  treatment,
  quiet = TRUE
)
}
\arguments{
\item{data_matrix_list}{\code{SimDataList}. The list of lists of data matrices created
with \code{sim_data_list()}.}

\item{covariate}{\code{SimCovariateList} or \code{Covariate} or \code{NULL}. List of \code{Covariate} objects created
with \code{sim_covariate()}, a single \code{Covariate} object created by \code{add_covariates()},
or \code{NULL} (no covariate adjustment).}

\item{outcome}{\code{SimOutcomeList} or \code{Outcome}. List of \code{Outcome} objects created with
\code{sim_outcome()}, or single \code{Outcome} object (e.g., created by \code{outcome_surv_exponential()}).}

\item{borrowing}{\code{SimBorrowingList} or \code{Borrowing}. List of \code{Borrowing} objects created
with \code{sim_borrowing()}, or a single \code{Borrowing} object created by \code{borrowing_full()},
\code{borrowing_none()}, or \code{borrowing_hierarchical_commensurate()}.}

\item{treatment}{\code{SimTreatmentList} or \code{Treatment}. List of \code{Treatment} objects created
with \code{sim_treatment()} or a single \code{Treatment} object created by \code{treatment_details()}.}

\item{quiet}{logical. Whether to print messages (\code{quiet = FALSE}) or not
(\code{quiet = TRUE}, the default)}
}
\value{
Object of class \code{\link[=Simulation-class]{Simulation}}.
}
\description{
Compile MCMC sampler using STAN and create simulation object
}
\examples{
base_mat <- matrix(
  c(
    rep(0, 200), rep(0, 200), rep(1, 200),
    rep(1, 200), rep(0, 200), rep(0, 200),
    rep(0, 600)
  ),
  ncol = 3,
  dimnames = list(NULL, c("ext", "trt", "driftOR"))
)

add_binary_endpoint <- function(odds_ratio,
                                base_matrix = base_mat) {
  linear_predictor <- base_matrix[, "trt"] * log(odds_ratio)
  prob <- 1 / (1 + exp(-linear_predictor))

  bin_endpoint <- rbinom(
    NROW(base_matrix),
    1,
    prob
  )

  cbind(base_matrix, matrix(bin_endpoint, ncol = 1, dimnames = list(NULL, "ep")))
}

data_list <- list(
  list(add_binary_endpoint(1.5), add_binary_endpoint(1.5)),
  list(add_binary_endpoint(2.5), add_binary_endpoint(2.5))
)

guide <- data.frame(
  trueOR = c(1.5, 2.5),
  driftOR = c(1.0, 1.0),
  index = 1:2
)

sdl <- sim_data_list(
  data_list = data_list,
  guide = guide,
  effect = "trueOR",
  drift = "driftOR",
  index = "index"
)

if (check_cmdstan()) {
  sim_object <- create_simulation_obj(
    data_matrix_list = sdl,
    outcome = outcome_bin_logistic("ep", prior_normal(0, 1000)),
    borrowing = sim_borrowing_list(list(
      full_borrowing = borrowing_full("ext"),
      bdb = borrowing_hierarchical_commensurate("ext", prior_exponential(0.0001))
    )),
    treatment = treatment_details("trt", prior_normal(0, 1000))
  )
}
}
