% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{points.ternary}
\alias{points.ternary}
\alias{lines}
\alias{text}
\title{Ternary point plotting}
\usage{
\method{points}{ternary}(x, ...)
}
\arguments{
\item{x}{an object of class \code{ternary}, or a three-column data
frame or matrix}

\item{...}{optional arguments to the generic \code{points} function}
}
\description{
Add points to an existing ternary diagram
}
\examples{
tern <- ternary(Namib$PT,'Q',c('KF','P'),c('Lm','Lv','Ls'))
plot(tern,pch=21,bg='red',labels=NULL)
# add the geometric mean composition as a yellow square:
gmean <- ternary(exp(colMeans(log(tern$x))))
points(gmean,pch=22,bg='yellow')
}
