% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visprov.R
\name{prov.visualize}
\alias{prov.visualize}
\alias{prov.visualize.file}
\alias{prov.visualize.run}
\title{prov.visualize}
\usage{
prov.visualize()

prov.visualize.file(prov.file)

prov.visualize.run(r.script.path, ...)
}
\arguments{
\item{prov.file}{the name of a file containing provenance that has been
created by rdt or rdtLite, or another tool producing compatible
provenance output.}

\item{r.script.path}{The path to an R script.  This script will be 
executed with provenance captured by the specified tool.}

\item{...}{If r.script.path is set, these parameters will be passed to prov.run to 
control how provenance is collected.  
See rdt's prov.run function
or rdtLites's prov.run function for details.}
}
\description{
prov.visualize displays the provenance graph for the last provenance
collected in this R session.

prov.visualize.file displays provenance stored in a file graphically

prov.visualize.run runs an R script and displays its provenance graph visually.
}
\details{
These functions use provenance collected using the rdtLite or rdt packages.

These functions do nothing when called non-interactively.
}
\examples{
\dontrun{prov.visualize ()}
testdata <- system.file("testdata", "prov.json", package = "provViz")
prov.visualize.file (testdata)
\dontrun{prov.visualize.run ("script.R")}
\dontrun{prov.visualize.run ("script.R", tool = "rdtLite")}
}
