% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SepDimers.R
\name{hmm_SepDim}
\alias{hmm_SepDim}
\title{hmm_SepDim}
\usage{
hmm_SepDim(hmm, l = 7)
}
\arguments{
\item{hmm}{The name of a profile hidden markov model file.}

\item{l}{Spatial distance between dimer residues.}
}
\value{
A vector of length 400
}
\description{
This feature calculates the probabilistic expression of amino acid dimers that are spatially separated by a distance \eqn{l}.
Mathematically, this is done with a 20 x 20 matrix \eqn{F}, in which \eqn{F[m, n] = \sum_{i = 1}^{L-l} H_{i, m}H_{i+k, n}}.
\eqn{H} corresponds to the original HMM matrix, and \eqn{L} is the number of rows in \eqn{H}. Matrix \eqn{F} is then flattened to
a feature vector of length 400, and returned.
}
\examples{
h<- hmm_SepDim(system.file("extdata", "1DLHA2-7", package="protHMM"))

}
\references{
Saini, H., Raicar, G., Sharma, A., Lal, S. K., Dehzangi, A., Lyons, J., Paliwal, K. K., Imoto, S., & Miyano, S. (2015).
Probabilistic expression of spatially varied amino acid dimers into general form of Chou's pseudo amino acid composition for protein fold recognition.
Journal of Theoretical Biology, 380, 291–298.
}
