% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_functions.R
\name{var_Delta_T}
\alias{var_Delta_T}
\title{Variance function of difference process}
\usage{
var_Delta_T(x, kmModel, simupoints, T.mat, F.mat)
}
\arguments{
\item{x}{a matrix \eqn{r x d} containing the \eqn{r} points where the function is to be computed.}

\item{kmModel}{the \link[DiceKriging]{km} model of the Gaussian process \eqn{Z}.}

\item{simupoints}{the matrix \eqn{l x d} containing the pilot points \eqn{G}.}

\item{T.mat}{the upper triangular factor of the Choleski decomposition of the covariance matrix of \code{rbind(kmModel@X,simupoints)}}

\item{F.mat}{the evaluation of the trend function at \code{rbind(kmModel@X,simupoints)}, see \link[stats]{model.matrix}.}
}
\value{
the value of the variance function at \code{x} for the difference process \eqn{Z^\Delta = Z_x - \widetilde{Z}_x}.
}
\description{
The function var_Delta_T computes the gradient for the variance function of the difference process \eqn{Z_x - \widetilde{Z}_x} at \code{x}.
}
\author{
Dario Azzimonti
}
