% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.grid.prevR.r
\name{make.grid.prevR}
\alias{make.grid.prevR}
\title{Create a spatial grid from an object of class prevR.}
\usage{
make.grid.prevR(object, nb.cells = 100, cell.size = NULL)
}
\arguments{
\item{object}{object of class \linkS4class{prevR}.}

\item{nb.cells}{number of cells on the longest side of the studied area
(unused if \code{cell.size} is defined).}

\item{cell.size}{size of each cell (in the unit of the projection).}
}
\value{
Object of class \link[sf:sfc]{sf::sfc} (simple feature geometry list column).
}
\description{
This function generates a spatial rectangular grid from the slot
\code{boundary} of an object of class \code{\linkS4class{prevR}}; function used in
particular by the methods \code{\link[=kde]{kde()}}, \code{\link[=krige]{krige()}} and \code{\link[=idw]{idw()}}.
}
\details{
This function generates a spatial rectangular grid, each cell
corresponding to the center of a square of side \code{cell.size}.
If \code{cell.size} is not defined, side of cells will be
calculated as the longest side of the slot \code{boundary} of \code{object}
divided by \code{nb.cells}.
}
\examples{
make.grid.prevR(fdhs)
make.grid.prevR(fdhs, nb.cells = 200)
}
\seealso{
\code{\link[sf:st_make_grid]{sf::st_make_grid()}}
}
\keyword{manip}
\keyword{spatial}
