% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pref_tools.R
\name{pref_trunc}
\alias{pref_trunc}
\title{Truncate preferences to a maximum number of ranks.}
\usage{
pref_trunc(x, n = 1L, bottom = FALSE)
}
\arguments{
\item{x}{A vector of \code{\link{preferences}}.}

\item{n}{The maximum number of ranks to include (positive) or number of ranks to drop (negative). Must be an integer.}

\item{bottom}{If \code{FALSE} (default), operates on top ranks. If \code{TRUE}, operates on bottom ranks.}
}
\value{
A vector of preferences with each selection truncated according to the parameters.
}
\description{
Truncate preferences to a maximum number of ranks.
}
\examples{
# Keep only the top 2 ranks
pref_trunc(preferences(c("a > b > c > d", "b > c > a")), n = 2)
# Keep only the bottom 2 ranks
pref_trunc(preferences(c("a > b > c > d", "b > c > a")), n = 2, bottom = TRUE)
# Drop the bottom 2 ranks (keep top ranks)
pref_trunc(preferences(c("a > b > c > d", "b > c > a")), n = -2)
# Drop the top 2 ranks (keep bottom ranks)
pref_trunc(preferences(c("a > b > c > d", "b > c > a")), n = -2, bottom = TRUE)
}
