% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATE_surv.R
\name{ipcw.surv}
\alias{ipcw.surv}
\title{Probability of being censored}
\usage{
ipcw.surv(
  y,
  d,
  x.ipcw,
  yf = NULL,
  ipcw.method = "breslow",
  tau0,
  surv.min = 0.025
)
}
\arguments{
\item{y}{Observed survival or censoring time; vector of size \code{n}.}

\item{d}{The event indicator, normally \code{1 = event, 0 = censored}; vector of size \code{n}.}

\item{x.ipcw}{Matrix of \code{p.ipw} baseline covariate specified in inverse probability of censoring weighting; dimension \code{n} by \code{p.ipw}.}

\item{yf}{Follow-up time, interpreted as the potential censoring time; vector of size \code{n} if the potential censoring time is known.
If unknown, set \code{yf == NULL} and \code{yf} will be taken as \code{y} in the function.}

\item{ipcw.method}{The censoring model. Allowed values are: \code{'breslow'} (Cox regression with Breslow estimator of the baseline survivor function),
\code{'aft (exponential)'}, \code{'aft (weibull)'}, \code{'aft (lognormal)'} or \code{'aft (loglogistic)'}. Default is \code{'breslow'}.}

\item{tau0}{The truncation time for defining restricted mean time lost.}

\item{surv.min}{Lower truncation limit for probability of being censored (positive and very close to 0).}
}
\value{
A vector of size \code{n} with the estimated probabilities \code{Pr(C > min(y, tau0) | x.ipcw)}
}
\description{
Probability of being censored which is used to correct the effect of right censoring.
}
