% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{use_docker}
\alias{use_docker}
\title{Use docker packaging tools}
\usage{
use_docker(
  pkg_path = ".",
  img_path = NULL,
  use_renv = TRUE,
  use_case = "default",
  base_image = NULL,
  other_packages = NULL,
  build = FALSE,
  repos = NULL,
  overwrite_assets = TRUE,
  overwrite_renv = TRUE,
  consent_renv = TRUE
)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{img_path}{Path to the write the docker image definition contents. The default \code{NULL} will use \verb{docker/} as a subdirectory of the \code{pkg_path}.}

\item{use_renv}{Logical; use renv? Defaults to \code{TRUE}. If \code{FALSE}, package dependencies are scraped from the \code{DESCRIPTION} file without version information.}

\item{use_case}{Name of the use case. Defaults to \code{"default"}, which only uses the base boilerplate.}

\item{base_image}{Name of the base image to start \code{FROM}. Default is \code{NULL} and the base image will be derived based on \code{use_case}. Optionally override this by setting the name of the base image (including tag if desired).}

\item{other_packages}{Vector of other packages to be included in \code{renv} lock file; default is \code{NULL}.}

\item{build}{Logical as to whether or not the image should be built. Default is \code{TRUE}, and if \code{FALSE} the \verb{docker build} command will be messaged.  Setting \code{build=FALSE} could be useful if additional \verb{docker build} options or different tags are desired. In either case the \verb{docker build} command will be returned invisibly.}

\item{repos}{Option to override the repos used for installing packages with \code{renv} by passing name of repository. Only used if \code{use_renv = TRUE}. Default is \code{NULL} meaning that the repos specified in \code{renv} lockfile will remain as-is and not be overridden.}

\item{overwrite_assets}{Logical; should existing asset files should be overwritten? Default is \code{TRUE}.}

\item{overwrite_renv}{Logical; should an existing lock file should be overwritten? Default is \code{TRUE}; ignored if \code{use_renv = TRUE}.}

\item{consent_renv}{Logical; give renv consent in this session with \code{options(renv.consent = TRUE)}? Default is \code{TRUE}. See \link[renv:consent]{renv::consent} for details.}
}
\value{
Invisibly returns a list with information about the package (\verb{$info}) and
the \verb{docker build} command (\verb{$buildcmd}). Primarily called for side effect.
Creates \verb{docker/} directory, identifies renv dependencies and creates lock
file (if \code{use_renv = TRUE}), writes Dockerfile, builds package tar.gz,
moves all relevant assets to the \verb{docker/} directory, and builds Docker
image (if \code{build = TRUE}).
}
\description{
Wrapper function around other \code{pracpac} functions. See help for the functions linked below for detail on individual functions.
All arguments to \code{use_docker()} are passed to downstream functions. \code{use_docker()} will sequentially run:
\enumerate{
\item \link{pkg_info} to get information about the current R package.
\item \link{create_docker_dir} to create the \verb{docker/} directory in the specified location, if it doesn't already exist.
\item \link{renv_deps} (if \code{use_renv=TRUE}, the default) to capture package dependencies with renv and create an \code{renv.lock} file
\item \link{add_dockerfile} to create a Dockerfile using template specified by \code{use_case}
\item \link{add_assets} depending on the \code{use_case}
\item \link{build_pkg} to build the current R package source .tar.gz, and place it into the \verb{docker/} directory
\item \link{build_image} optional, default \code{FALSE}; if TRUE, will build the Docker image.
}

The default \code{build=FALSE} means that everything up to \code{build_image()} is run,
but the image is not actually built. Instead, \code{use_docker()} will message the
\verb{docker build} command, and return that string in \verb{$buildcmd} in the
invisibly returned output.

See \code{vignette("use-cases", package="pracpac")} for details on use cases.
}
\examples{
\dontrun{

# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# Run use_docker to create Docker directory and assets for the example package
use_docker(pkg_path = file.path(tempdir(), "hellow"))
# To not use renv
use_docker(pkg_path = file.path(tempdir(), "hellow"), use_renv=FALSE)
# To specify a use case
use_docker(pkg_path = file.path(tempdir(), "hellow"), use_case="pipeline")
# To overwrite the default base image
use_docker(pkg_path = file.path(tempdir(), "hellow"), base_image="alpine:latest")
}
}
