% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{renv_deps}
\alias{renv_deps}
\title{Get dependencies using renv}
\usage{
renv_deps(
  pkg_path = ".",
  img_path = NULL,
  other_packages = NULL,
  overwrite = TRUE,
  consent_renv = TRUE
)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{img_path}{Path to the write the docker image definition contents. The default \code{NULL} will use \verb{docker/} as a subdirectory of the \code{pkg_path}.}

\item{other_packages}{Vector of other packages to be included in \code{renv} lock file; default is \code{NULL}.}

\item{overwrite}{Logical; should an existing lock file should be overwritten? Default is \code{TRUE}.}

\item{consent_renv}{Logical; give renv consent in this session with \code{options(renv.consent = TRUE)}? Default is \code{TRUE}. See \link[renv:consent]{renv::consent} for details.}
}
\value{
Invisibly returns a list of package info returned by \link{pkg_info}. Primarily called for side effect. Writes an \code{renv} lock file to the docker/ directory.
}
\description{
Get dependencies using renv. This function will inspect your package specified
at \code{pkg_path} (default is current working directory, \code{.}), and create an renv lock file (\code{renv.lock}) in
the \verb{docker/} directory. More information about the \code{renv} implementation is provided in the Details section.
}
\details{
The \code{renv.lock} file will capture all your package's dependencies (and all
their dependencies) at the current version installed on your system at the
time this function is run. When using the default \code{use_renv=TRUE} in
\link{use_docker} or \link{add_dockerfile}, the resulting \code{Dockerfile} will install
packages from this \code{renv.lock} file using \link[renv:restore]{renv::restore}. This ensures that
versions of dependencies in the image mirror what is installed on your system
at the time of image creation, rather than potentially newer versions on package repositories like
CRAN or Bioconductor, which may come with breaking changes that you are unaware of at the
time of package development.

If there are additional R packages that may be useful for the Docker image you plan to build (but may not be captured under your package dependencies), then you can add these packages to the \code{renv} procedure with the "other_packages" argument.

This function is run as part of \link{use_docker} but can be used on its own.
}
\examples{
\dontrun{
# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# Run using defaults; only gets current package dependencies
renv_deps(pkg_path = file.path(tempdir(), "hellow"))
# Add additional packages not explicitly required by your package
renv_deps(pkg_path = file.path(tempdir(), "hellow"), other_packages=c("shiny", "knitr"))
}
}
