% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.data.ppls.R
\name{sim.data.ppls}
\alias{sim.data.ppls}
\title{Simulate Data for Penalized Partial Least Squares (PPLS)}
\usage{
sim.data.ppls(ntrain, ntest, stnr, p, a = NULL, b = NULL)
}
\arguments{
\item{ntrain}{Integer. Number of training observations.}

\item{ntest}{Integer. Number of test observations.}

\item{stnr}{Numeric. Signal-to-noise ratio (higher means less noise).}

\item{p}{Integer. Number of predictors (must be \code{>= 5}).}

\item{a}{Optional numeric vector of length 5. Linear coefficients for the first 5 variables. If \code{NULL}, drawn uniformly from \code{[-1, 1]}.}

\item{b}{Optional numeric vector of length 5. Nonlinear sine coefficients. If \code{NULL}, drawn uniformly from \code{[-1, 1]}.}
}
\value{
A list with the following components:
\describe{
\item{Xtrain}{\code{ntrain x p} matrix of training predictors (uniform in \code{[-1, 1]}).}
\item{ytrain}{Numeric vector of training responses.}
\item{Xtest}{\code{ntest x p} matrix of test predictors.}
\item{ytest}{Numeric vector of test responses.}
\item{sigma}{Standard deviation of the added noise.}
\item{a}{Linear coefficients used in the simulation.}
\item{b}{Nonlinear sine coefficients used in the simulation.}
}
}
\description{
Generates a training and test dataset with non-linear relationships between predictors and response, as used in PPLS simulation studies.
}
\details{
The function simulates a response variable \code{y} as a combination of additive linear and sinusoidal effects of the first 5 predictors:
\deqn{f(x) = \sum_{j=1}^{5} a_j x_j + \sin(6 b_j x_j)}
The response \code{y} is then generated by adding Gaussian noise scaled to match the specified signal-to-noise ratio (stnr).

Remaining variables (\code{p - 5}) are included as noise variables, making the dataset suitable to evaluate selection or regularization methods.
}
\examples{
set.seed(123)
sim <- sim.data.ppls(ntrain = 100, ntest = 100, stnr = 3, p = 10)
str(sim)
plot(sim$Xtrain[, 1], sim$ytrain, main = "Effect of x1 on y")

}
\seealso{
\code{\link{ppls.splines.cv}}, \code{\link{graphic.ppls.splines}}
}
