% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov_decomp.R
\name{vcov_decomp}
\alias{vcov_decomp}
\title{Decompose the posterior of a variance-covariance node}
\usage{
vcov_decomp(
  post,
  param,
  sigma_base_name = "sigma",
  rho_base_name = "rho",
  invert = FALSE,
  check = TRUE,
  auto_escape = TRUE
)
}
\arguments{
\item{post}{A \code{\link[coda:mcmc.list]{mcmc.list}} object.}

\item{param}{A vector of regular expressions specifying the nodes to match for plotting.
Must match only one base node name in \code{post}, and that node must store samples from a matrix within the model.
See \code{\link[=match_params]{match_params()}} and \code{vignette("pattern-matching")} for more details.}

\item{sigma_base_name}{Base node name to assign to the standard deviation vector component?
Defaults to \code{"sigma"}, which becomes \code{"sigma[1]"}, \code{"sigma[2]"}, etc. in the output.}

\item{rho_base_name}{Same as \code{sigma_base_name}, but for the correlation matrix component.}

\item{invert}{Take the inverse of the matrix node matched by \code{param}
prior to performing the calculations? This would be necessary if the matrix node was expressed as
a precision matrix as used in the BUGS language. Triggers a call to \code{\link[base:solve]{base::solve()}}.}

\item{check}{Perform checks sequentially that the matrix node is (a) square, (b) symmetrical, and (c) positive definite
before proceeding with the calculations? If set to \code{FALSE}, unexpected output may be returned or
other errors related to items a, b, and c may be triggered - this is not advised, though may be required
if wishing to set \code{invert = TRUE}.}

\item{auto_escape}{Automatically escape \code{"["} and \code{"]"} characters for pattern matching?
See \code{\link[=match_params]{match_params()}} for details.}
}
\value{
A \code{\link[coda:mcmc.list]{mcmc.list}} object.
}
\description{
For each posterior sample, extract the standard deviation and correlation components
of a monitored node representing a variance-covariance matrix.
}
\examples{
# load example mcmc.list
data(cjs)

# "SIG" is a covariance matrix node
SIG_decomp = vcov_decomp(cjs, "SIG")

# extract the posterior mean correlation matrix, and reformat
array_format(post_summ(SIG_decomp, "rho")["mean",])
}
